//
//  $Id: AHKABMainWindowController.h 93 2009-06-11 14:55:36Z fujidana $
//  Copyright (c) 2005-2009 Fujidana All rights reserved.
//

#import <Cocoa/Cocoa.h>

extern NSString* AHKABDefaultsLastReceivedDateKey;
extern NSString* AHKABDefaultsLastSentDateKey;
extern NSString* AHKABDefaultsVCardFormatIndexKey;
extern NSString* AHKABDefaultsExportABGroupUIDKey; 
extern NSString* AHKABDefaultsIsCardNumberLimitedTo500Key;
extern NSString* AHKToolbarSearchItemIdentifier;

@class AHKPerson, AHKABArrayController;

typedef enum
{
	AHKABSearchAll = 1,
	AHKABSearchNameAndPhoneticName = 2, 
	AHKABSearchEveryPhoneNumber = 3, 
	AHKABSearchEveryEmailAddress = 4, 
	AHKABSearchAddress = 5, 
	AHKABSearchHobby = 6, 
	AHKABSearchURL = 7, 
	AHKABSearchNote = 8
} AHKABSearchKey;


@interface AHKABMainWindowController : NSWindowController
{
	NSMutableArray					*_people;
	
	BOOL							detachesInspector;
	NSDrawer						*inspectorDrawer;
	NSPanel							*inspectorPanel;
	
    IBOutlet AHKABArrayController	*peopleController;
	
	IBOutlet NSTableView			*peopleTableView;
	IBOutlet NSTextField			*numberTextField;
	IBOutlet NSView					*searchView;
	IBOutlet NSSearchField			*searchField;
	IBOutlet NSView					*inspectorView;

	IBOutlet NSView					*fileFormatView;
//	IBOutlet NSWindow				*viewOptionsWindow;
//	IBOutlet NSMatrix				*viewOptionsMatrix;
}

#pragma mark accessor methods
- (NSMutableArray *)people;
- (void)setPeople:(NSArray *)people;

#pragma mark accessor methods for to-many relationships
- (unsigned int)countOfPeople;
- (AHKPerson *)objectInPeopleAtIndex:(unsigned int)index;
//- (void)getPeople:(id *)people range:(NSRange)range;
- (void)insertObject:(AHKPerson *)person inPeopleAtIndex:(unsigned int)index;
- (void)removeObjectFromPeopleAtIndex:(unsigned int)index;
- (void)replaceObjectInPeopleAtIndex:(unsigned int)index withObject:(AHKPerson *)person;

#pragma mark for other menus
- (IBAction)toggleInspector:(id)sender;
- (IBAction)selectNext:(id)sender;
- (IBAction)selectPrevious:(id)sender;
- (IBAction)add:(id)sender;
- (IBAction)insert:(id)sender;
- (IBAction)delete:(id)sender;
- (IBAction)find:(id)sender;
//- (IBAction)findSelection:(id)sender;
- (IBAction)sortPeopleInNumberingOrder:(id)sender;
- (IBAction)deselectSort:(id)sender;
- (IBAction)renumberSelection:(id)sender;
- (IBAction)listDoubleEntries:(id)sender;

#pragma mark other methods
- (void)searchForString:(NSString *)string options:(int)option;

@end

#pragma mark -

@interface AHKABMainWindowController (Toolbar)
- (void)setupToolbar;
@end

#pragma mark -

@interface AHKABMainWindowController (IO)
- (IBAction)importVCards:(id)sender;
- (IBAction)exportVCards:(id)sender;
- (IBAction)importFromAddressBook:(id)sender;
- (IBAction)exportToAddressBook:(id)sender;
- (IBAction)backupDatabase:(id)sender;
- (IBAction)revertFromDatabaseBackup:(id)sender;
- (IBAction)receivePeople:(id)sender;
- (IBAction)sendPeople:(id)sender;

- (void)confirmRevertDatabaseFromFile:(NSString *)filename;
- (BOOL)loadDefaultDatabase;
- (BOOL)storeDefaultDatabase;
- (NSArray *)acceptableFileExtensions;

@end

#pragma mark -

@interface AHKABMainWindowController (Pasteboard)
- (NSArray *)distributablePasteboardTypes;
- (NSArray *)acceptablePasteboardTypes;
- (BOOL)writePeopleAtIndexes:(NSIndexSet *)rowIndexes toPasteboard:(NSPasteboard *)pboard types:(NSArray *)types;
- (BOOL)insertPeopleFromPasteboard:(NSPasteboard *)pboard atRow:(int)row;

@end

//@interface AHKABMainWindowController (ViewOptions)
//- (IBAction)showViewOptions:(id)sender;
//- (IBAction)resetViewOptions:(id)sender;
//
//+ (NSArray *)defaultViewOptions;
//- (NSArray *)selectedViewOptions;
//- (void)setupTableViewWithViewOptions;
//- (int)viewOptionsTagForIdentifier:(NSString *)string;
//- (NSString *)viewOptionsIdentifierForTag:(int)tag;
//@end